//Tab view header file
#ifndef _SGB_TAB_VIEW_H_
#define _SGB_TAB_VIEW_H_


//******************************************************************************************************
//**** SYSTEM HEADER FILES
//******************************************************************************************************
#include <View.h>


//******************************************************************************************************
//**** ColumnListView CLASS DECLARATION
//******************************************************************************************************
class TabView : public BView
{
	public:
		//Constructor and destructor
		TabView(BRect frame, const char *name, const char** names, int32 number_of_views,
			uint32 resizingMode =  B_FOLLOW_LEFT | B_FOLLOW_TOP, uint32 flags = B_NAVIGABLE | B_WILL_DRAW |
			B_FRAME_EVENTS, const BFont *labelFont = be_plain_font);
		BRect GetContentArea();
		float GetTabsWidth();
		void AddViews(BView** tabbedViews);
		~TabView();
		virtual void Draw(BRect updateRect);
		virtual void MouseDown(BPoint point);
		virtual void FrameResized(float width, float height);
		virtual void SelectTab(int32 index);

	private:
		char** fNames;
		BView** fViews;
		int32 fNumberOfViews;
		float fTabViewBottom;
		BPoint* LabelPosition;
		BRect* LabelRect;
		int32 fCurrentlyShowing;
		BRect* fTabRect;
		BRect* fLabelRect;
		BPoint* fLabelPosition;
		BRect fBounds;
		BRect fContentArea;
};


#endif
